<!DOCTYPE html>
<html lang="tr">

<head>

    <link rel="icon" href="assets/images/favicon/4.png" type="image/x-icon">
    <link rel="apple-touch-icon" href="assets/images/favicon/4.png">
    <meta name="theme-color" content="#51983c">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black">
    <meta name="apple-mobile-web-app-title" content="Voxo">
    <meta name="msapplication-TileImage" content="assets/images/favicon/4.png">
    <meta name="msapplication-TileColor" content="#FFFFFF">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">

    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Welldress | Spor Gecelik / Sabahlık">
    <meta name="keywords" content="Welldress | Spor Gecelik / Sabahlık">
    <meta name="author" content="Lasera Medya">
    <link rel="icon" href="<?php echo e(asset('assets/images/favicon/6.png')); ?>" type="image/x-icon"/>
    <title>Welldress | Spor Gecelik / Sabahlık</title>

    <!-- Google font -->
    <link rel="preconnect" href="https://fonts.gstatic.com/">
    <link href="https://fonts.googleapis.com/css2?family=Rubik:wght@400;500;600;700&amp;display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;500;600;700;800;900&amp;display=swap"
          rel="stylesheet">

    <!-- bootstrap css -->
    <link id="rtl-link" rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/vendors/bootstrap.css')); ?>">

    <!-- font-awesome css -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/vendors/font-awesome.css')); ?>">

    <!-- feather icon css -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/vendors/feather-icon.css')); ?>">

    <!-- animation css -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/vendors/animate.css')); ?>">

    <!-- slick css -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/vendors/slick/slick.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/vendors/slick/slick-theme.css')); ?>">

    <!-- Theme css -->
    <link id="color-link" rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/demo6.css')); ?>">

    <!-- Theme css -->
    <link id="color-link" rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/demo3.css')); ?>">
    <link rel="stylesheet" href="//cdn.jsdelivr.net/npm/alertifyjs@1.13.1/build/css/alertify.min.css"/>
    <script src="<?php echo e(asset('js/app.js')); ?>" defer></script>


</head>


<body class="theme-color6 light ltr">
<style>
    a.pointer:hover {
        cursor: pointer;
    }
</style>
<div x-data="aData()" x-init="init()">
<?php echo $__env->make('partials.header2', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>




<!-- Breadcrumb section start -->

    <section class="breadcrumb-section section-b-space">

        <ul class="circles">

            <li></li>

            <li></li>

            <li></li>

            <li></li>

            <li></li>

            <li></li>

            <li></li>

            <li></li>

            <li></li>

            <li></li>

        </ul>

        <div class="container">

            <div class="row">

                <div class="col-12">

                    <h3>Siparişi Onayla</h3>

                    <nav>

                        <ol class="breadcrumb">

                            <li class="breadcrumb-item">

                                <a href="<?php echo e(url('/')); ?>">

                                    <i class="fas fa-home"></i>

                                </a>

                            </li>

                            <li class="" aria-current="page">Anasayfa</li>

                        </ol>

                    </nav>

                </div>

            </div>

        </div>

    </section>

    <!-- Breadcrumb section end -->

    <!-- Cart Section Start -->

    <section class="section-b-space">

        <div class="container">

            <div class="col-lg-12">

                <!--            <h4 style="text-align: center">Şimdi <a href="uye-ol.php">Üye ol</a> %5 İndirim Kazan</h4>-->
                <template x-if="error">
                    <div class="alert alert-danger">
                        <ul>
                            <template x-for="[id, value] in Object.entries(errors)" :key="id">
                                <li class="d-block" x-text="value"></li>
                            </template>
                        </ul>
                    </div>
                </template>
            </div>

            <div class="row g-4">

                <div class="col-lg-8">

                    <h3 class="mb-3">Bilgiler</h3>

                    <form class="needs-validation">

                        <div class="row g-4">

                            <div class="col-md-6">

                                <label for="first_name" class="form-label">Adınız</label>

                                <input type="text" x-model="payment_details.first_name" class="form-control"
                                       id="first_name" placeholder="Adınızı Girin">

                            </div>

                            <div class="col-md-6">

                                <label for="last_name" class="form-label">Soyadınız</label>

                                <input type="text" x-model="payment_details.last_name" class="form-control"
                                       id="last_name" placeholder="Soyadınızı Girin">

                            </div>

                            <div class="col-md-12">

                                <label for="last_name" class="form-label">Tc Kimlik No</label>

                                <input type="text"
                                       oninput="this.value = this.value.replace(/[^0-9]/g, '').replace(/(\..*)\./g, '$1');"
                                       x-model="payment_details.tc_number" class="form-control"
                                       id="tc_number" placeholder="Tc Kimlik No Girin" maxlength="11">

                            </div>


                            


                            <div class="col-md-6">

                                <label for="email" class="form-label">E-Mail Adresiniz</label>

                                <input type="email" x-model="payment_details.email" class="form-control" id="email"
                                       placeholder="example@example.com"

                                       required>

                            </div>


                            <div class="col-md-6">

                                <label for="phone" class="form-label">Telefon</label>

                                <input type="text" x-model="payment_details.phone" class="form-control" id="phone"
                                       placeholder=""
                                       required>

                            </div>


                            <div class="col-md-12">

                                <label for="address" class="form-label">Adres</label>

                                <input type="text" x-model="payment_details.address" class="form-control" id="address"
                                       aria-describedby="emailHelp"

                                       placeholder="1234 Ana Cadde" required>

                                <div class="invalid-feedback">

                                    Gönderim güncellemeleri için lütfen geçerli bir e-posta adresi girin.

                                </div>

                            </div>


                            <div class="col-md-6">

                                <label for="province" class="form-label">Şehir</label>

                                <select class="form-select custome-form-select" id="province"
                                        x-model="payment_details.province" @change="selectCity($event.target.value)">

                                    <option value="">Seçiniz</option>
                                    <?php $__currentLoopData = $cities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $city): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($city->isim); ?>"><?php echo e($city->isim); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </select>

                                <div class="invalid-feedback">

                                    Lütfen geçerli bir Şehir seçin.

                                </div>

                            </div>

                            <div class="col-md-6">

                                <label for="district" class="form-label">İlçe</label>

                                <select class="form-select custome-form-select" x-model="payment_details.district"
                                        id="district">
                                    <template x-for="country in countries">
                                        <option :value="country.isim"
                                                x-text="country.isim"></option>
                                    </template>
                                </select>

                                <div class="invalid-feedback">

                                    Lütfen geçerli bir İlçe Seçin.

                                </div>

                            </div>

                            <div class="col-md-6">

                                <label for="zip_code" class="form-label">Posta kodu</label>

                                <input type="text" x-model="payment_details.zip_code" class="form-control" id="zip_code"
                                       aria-describedby="emailHelp"

                                       placeholder="">

                            </div>
                            <div class="col-md-6">

                                <label for="burc" class="form-label">Burcunuz</label>

                                <select class="form-select custome-form-select" id="burc"
                                        x-model="payment_details.burc">

                                    <option value="">Seçiniz</option>

                                    <option value="koc">Koç</option>
                                    <option value="boga">Boğa</option>
                                    <option value="ikizler">İkizler</option>
                                    <option value="yengec">Yengeç</option>
                                    <option value="aslan">Aslan</option>
                                    <option value="basak">Başak</option>
                                    <option value="terazi">Terazi</option>
                                    <option value="akrep">Akrep</option>
                                    <option value="yay">Yay</option>
                                    <option value="oglak">Oğlak</option>
                                    <option value="kova">Kova</option>
                                    <option value="balık">Balık</option>


                                </select>

                                <div class="invalid-feedback">

                                    Lütfen burç seçin.

                                </div>

                            </div>

                        </div>

                        


                        <hr class="my-lg-5 my-4">


                        

                        

                        

                    </form>

                </div>


                <div class="col-lg-4">

                    <div class="your-cart-box">

                        <h3 class="mb-3 d-flex text-capitalize">Sepetiniz<span

                                    class="badge bg-theme new-badge rounded-pill ms-auto bg-dark"
                                    x-text="cart_products.length">3</span>

                        </h3>

                        <ul class="list-group mb-3">

                            <template x-for="cart_product in cart_products">
                                <li class="list-group-item d-flex justify-content-between lh-condensed row m-0">

                                    <div class="col-12 p-0">

                                        <h6 class="my-0" x-text="cart_product.product.name"></h6>

                                        

                                    </div>
                                    <div class="col-12 text-end p-0">
                                        <span x-text="cart_product.product.sale_price+' ₺'"></span>
                                        <span class="mx-3" x-text="cart_product.quantity+' Adet'"></span>
                                        <span x-text="cart_product.total_price+' ₺'"></span>
                                    </div>

                                </li>
                            </template>
                            <li class="list-group-item d-flex justify-content-between lh-condensed row m-0">

                                <div class="col-12 p-0">

                                    <h6 class="my-0" x-text="cargo_price==0 ? 'Kargo Ücretsiz' : 'Kargo'"></h6>

                                </div>
                                <div class="col-12 text-end p-0">
                                    <span x-text="cargo_price+' ₺'"></span>
                                </div>

                            </li>


                            

                            

                            <li class="list-group-item d-flex lh-condensed justify-content-between">

                                <span class="fw-bold">Toplam (TRY)</span>

                                <strong x-text="(cart_total+cargo_price)+' ₺'"></strong>

                            </li>

                        </ul>

                        <button class="btn btn-solid-default mt-4" id="checkout_btn" @click="checkout()">Ödemeye Devam
                            Et
                        </button>

                        

                    </div>

                </div>

            </div>

        </div>

    </section>

    <!-- Cart Section End -->


<?php echo $__env->make('partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>



<!-- tap to top Section Start -->
    <div class="tap-to-top">
        <a href="#home">
            <i class="fas fa-chevron-up"></i>
        </a>
    </div>
    <!-- tap to top Section End -->


    <div class="bg-overlay"></div>
</div>
<div id="iyzipay-checkout-form" class="responsive" style=""></div>
<!-- latest jquery-->
<script src="<?php echo e(asset('assets/js/jquery-3.5.1.min.js')); ?>"></script>

<!-- Bootstrap js-->


<!-- feather icon js-->
<script src="<?php echo e(asset('assets/js/feather/feather.min.js')); ?>"></script>


<!-- lazyload js-->
<script src="<?php echo e(asset('assets/js/lazysizes.min.js')); ?>"></script>


<!-- Notify js-->


<!-- script js -->

<script src="<?php echo e(asset('assets/js/script.js')); ?>"></script>
<?php echo $__env->yieldContent('js'); ?>


<script>

    <?php if($errors->any()): ?>
    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    alertify.warning('<?php echo e($error); ?>');
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>

    <?php if(Session::has('message')): ?>

    <?php endif; ?>
</script>

<script>

    $('.color-image li').on('click', function () {
        $('.image-section-2 li').removeClass('active');
        ($(this).addClass('active'));

    });

    function aData() {
        return {
            cart_products: [],
            search_products: [],
            select_product: [],
            search: '',
            auth_user: [],
            cart_total: 0,
            color: [],
            size: null,
            payment_details: {
                first_name: '',
                last_name: '',
                tc_number: '',
                email: '',
                phone: '',
                address: '',
                province: '',
                district: '',
                zip_code: '',
                burc: '',
            },
            errors: [],
            error: false,
            cargo_price: 0,
            countries: [],
            init() {
                //this.getAuthUser();
                this.$watch('cart_products', value => this.calcTotal(value));
                this.$watch('search', value => this.findProducts(value));
                this.getCartProducts();
            },
            quickView(product_id) {
                const request = new Request('<?php echo e(url('get-find-product')); ?>', {
                    headers: {
                        "Content-Type": "application/json",
                        "Accept": "application/json, text-plain, */*",
                        "X-Requested-With": "XMLHttpRequest",
                        "X-CSRF-TOKEN": '<?php echo e(csrf_token()); ?>',
                    },
                    method: 'POST',
                    credentials: "same-origin",
                    body: JSON.stringify({"id": product_id})
                });

                fetch(request)
                    .then(r => r.json().then(data => ({status: r.status, body: data})))
                    .then(obj => {
                        console.log(obj.body);
                        this.select_product = obj.body;
                    });
                var myModal = new bootstrap.Modal(document.getElementById('quick-view'), {});
                myModal.show();
            },
            findProducts(value) {
                const request = new Request('<?php echo e(url('get-search-products')); ?>', {
                    headers: {
                        "Content-Type": "application/json",
                        "Accept": "application/json, text-plain, */*",
                        "X-Requested-With": "XMLHttpRequest",
                        "X-CSRF-TOKEN": '<?php echo e(csrf_token()); ?>',
                    },
                    method: 'POST',
                    credentials: "same-origin",
                    body: JSON.stringify({"search": value})
                });

                fetch(request)
                    .then(r => r.json().then(data => ({status: r.status, body: data})))
                    .then(obj => {
                        this.search_products = obj.body
                    });
            },
            findProduct(id) {
                const request = new Request('<?php echo e(url('get-find-product')); ?>', {
                    headers: {
                        "Content-Type": "application/json",
                        "Accept": "application/json, text-plain, */*",
                        "X-Requested-With": "XMLHttpRequest",
                        "X-CSRF-TOKEN": '<?php echo e(csrf_token()); ?>',
                    },
                    method: 'POST',
                    credentials: "same-origin",
                    body: JSON.stringify({"id": id})
                });

                fetch(request)
                    .then(r => r.json().then(data => ({status: r.status, body: data})))
                    .then(obj => {
                        this.select_product = obj.body
                    });
            },
            cargo_calc() {
                this.cargo_price = 0;
                
                
                

            },
            getAuthUser() {
                const request = new Request('<?php echo e(url('get-auth-user')); ?>', {
                    headers: {
                        "Content-Type": "application/json",
                        "Accept": "application/json, text-plain, */*",
                        "X-Requested-With": "XMLHttpRequest",
                        "X-CSRF-TOKEN": '<?php echo e(csrf_token()); ?>',
                    },
                    method: 'POST',
                    credentials: "same-origin",
                });

                fetch(request)
                    .then(r => r.json().then(data => ({status: r.status, body: data})))
                    .then(obj => {
                        this.auth_user = obj.body;
                    });
            },
            setCartProduct(product_id, quantity = 1) {
                const request = new Request('<?php echo e(url('set-cart-products')); ?>', {
                    headers: {
                        "Content-Type": "application/json",
                        "Accept": "application/json, text-plain, */*",
                        "X-Requested-With": "XMLHttpRequest",
                        "X-CSRF-TOKEN": '<?php echo e(csrf_token()); ?>',
                    },
                    method: 'POST',
                    credentials: "same-origin",
                    body: JSON.stringify({
                        "product_id": product_id,
                        "quantity": quantity,
                        "color": this.color,
                        "size": this.size,
                    })
                });

                // fetch(request)
                //     .then(r => r.json().then(data => ({status: r.status, body: data})))
                //     .then(obj => {
                //         console.log(obj);
                //         this.updateCartProducts();
                //
                //         alertify.success('Ürün Sepete Eklendi');
                //     });

                // fetch(request)
                //     .then(r => r.json().then(data => ({status: r.status, body: data})))
                //     .then(obj => {
                //         console.log(obj);
                //         this.updateCartProducts();
                //
                //         alertify.success('Ürün Sepete Eklendi');
                //     });
                if (this.color.length > 0 && this.size) {
                    fetch(request)
                        .then(r => r.json().then(data => ({status: r.status, body: data})))
                        .then(obj => {
                            console.log(obj);
                            this.updateCartProducts();

                            alertify.success('Ürün Sepete Eklendi');
                        });
                } else {
                    if (this.color.length == 0)
                        alertify.warning('Ürün Sepete Eklenmedi. Renk Seçimi Zorunludur');

                    if (!this.size)
                        alertify.warning('Ürün Sepete Eklenmedi. Beden Seçimi Zorunludur');
                }


            },
            getCartProducts() {
                const request = new Request('<?php echo e(url('get-cart-products')); ?>', {
                    headers: {
                        "Content-Type": "application/json",
                        "Accept": "application/json, text-plain, */*",
                        "X-Requested-With": "XMLHttpRequest",
                        "X-CSRF-TOKEN": '<?php echo e(csrf_token()); ?>',
                    },
                    method: 'POST',
                    credentials: "same-origin",
                    //body: JSON.stringify({"name": data.name, "value": value})
                });

                fetch(request)
                    .then(r => r.json().then(data => ({status: r.status, body: data})))
                    .then(obj => {
                        this.cart_products = obj.body
                    });
            },
            deleteCartProduct(product_id, quantity = 0) {
                //quantity 0 ise hepsini siliyor

                const request = new Request('<?php echo e(url('delete-cart-products')); ?>', {
                    headers: {
                        "Content-Type": "application/json",
                        "Accept": "application/json, text-plain, */*",
                        "X-Requested-With": "XMLHttpRequest",
                        "X-CSRF-TOKEN": '<?php echo e(csrf_token()); ?>',
                    },
                    method: 'POST',
                    credentials: "same-origin",
                    body: JSON.stringify({
                        "product_id": product_id,
                        "quantity": quantity,
                    })
                });

                fetch(request)
                    .then(r => r.json().then(data => ({status: r.status, body: data})))
                    .then(obj => {
                        this.updateCartProducts();
                    });
            },
            chanceCartProductQuantity(product_id, quantity, size) {
                if (quantity < 1)
                    return;
                const request = new Request('<?php echo e(url('chance-cart-product-quantity')); ?>', {
                    headers: {
                        "Content-Type": "application/json",
                        "Accept": "application/json, text-plain, */*",
                        "X-Requested-With": "XMLHttpRequest",
                        "X-CSRF-TOKEN": '<?php echo e(csrf_token()); ?>',
                    },
                    method: 'POST',
                    credentials: "same-origin",
                    body: JSON.stringify({
                        "product_id": product_id,
                        "quantity": quantity,
                        "size": size,
                    })
                });

                fetch(request)
                    .then(r => r.json().then(data => ({status: r.status, body: data})))
                    .then(obj => {
                        this.updateCartProducts();
                    });
            },
            clearCartProducts() {
                this.cart_products.forEach(element => {
                    this.deleteCartProduct(element.product_id);
                });
            },
            calcTotal(p) {
                var total = 0;
                p.forEach(function (item, index) {
                    // item.product.sale_price=item.product.sale_price.toFixed(2);
                    total += item.product.sale_price * item.quantity;
                });
                this.cart_total = total;
                // this.cart_total = total.toFixed(2);

                this.cargo_calc();

            },
            orderCreate() {
                if (this.cart_products.length > 0) {
                    const request = new Request('<?php echo e(url('order-create')); ?>', {
                        headers: {
                            "Content-Type": "application/json",
                            "Accept": "application/json, text-plain, */*",
                            "X-Requested-With": "XMLHttpRequest",
                            "X-CSRF-TOKEN": '<?php echo e(csrf_token()); ?>',
                        },
                        method: 'POST',
                        credentials: "same-origin",
                        body: JSON.stringify({"cart_total": this.cart_total})
                    });

                    fetch(request)
                        .then(r => r.json().then(data => ({status: r.status, body: data})))
                        .then(obj => {
                            this.order = obj.body;
                            console.log(this.order);
                            this.updateCartProducts();
                        });
                }
            },
            updateCartProducts() {
                this.getCartProducts();
            },
            addToWishlist(p_id) {
                if (p_id != null) {

                    const request = new Request('<?php echo e(url('begendigim-urunler')); ?>', {
                        headers: {
                            "Content-Type": "application/json",
                            "Accept": "application/json, text-plain, */*",
                            "X-Requested-With": "XMLHttpRequest",
                            "X-CSRF-TOKEN": '<?php echo e(csrf_token()); ?>',
                        },
                        method: 'POST',
                        credentials: "same-origin",
                        body: JSON.stringify({
                            "product_id": p_id,
                        })
                    });

                    fetch(request)
                        .then(r => r.json().then(data => ({status: r.status, body: data})))
                        .then(obj => {
                            if (obj.body !== true)
                                alertify.success('Ürün Favorilere Eklendi');
                            else
                                alertify.warning('Ürün Favorilerden Silindi');
                        });
                } else {
                    alertify.warning('Tekrar Deneyiniz');
                }
            },
            checkout() {
                $('#checkout_btn').prop('disabled', true);
                const request = new Request('<?php echo e(url('checkout')); ?>', {
                    headers: {
                        "Content-Type": "application/json",
                        "Accept": "application/json, text-plain, */*",
                        "X-Requested-With": "XMLHttpRequest",
                        "X-CSRF-TOKEN": '<?php echo e(csrf_token()); ?>',
                    },
                    method: 'POST',
                    credentials: "same-origin",
                    body: JSON.stringify({
                        "cart_total": this.cart_total,
                        "payment_details": this.payment_details,
                    })
                });

                fetch(request)
                    .then(r => r.json().then(data => ({status: r.status, body: data})))
                    .then(obj => {
                        console.log(obj);
                        if (obj.body.errors) {
                            this.error = true;
                            this.errors = obj.body.errors;
                            $('#checkout_btn').prop('disabled', false);
                        } else {
                            let form = obj.body;
                            console.log(form);
                            console.log("--------------------------------------------------------------");
                            console.log((/Android|webOS|iPhone|iPad|iPod|BlackBerry/i.test(navigator.userAgent)));
                            console.log("--------------------------------------------------------------");
                            if (!(/Android|webOS|iPhone|iPad|iPod|BlackBerry/i.test(navigator.userAgent))) {

                                $("body").append(form);
                            } else {
                                $("#iyzipay-checkout-form").append(form);
                            }

                            //$('#checkout_btn').prop('disabled', false);
                        }


                    });

            },
            validateEmail(col) {
                alertify.warning(col);
            },
            selectCity(city) {
                const request = new Request('<?php echo e(url('getCountry')); ?>', {
                    headers: {
                        "Content-Type": "application/json",
                        "Accept": "application/json, text-plain, /",
                        "X-Requested-With": "XMLHttpRequest",
                        "X-CSRF-TOKEN": '<?php echo e(csrf_token()); ?>',
                    },
                    method: 'POST',
                    credentials: "same-origin",
                    body: JSON.stringify({"city_name": city})
                });

                fetch(request)
                    .then(r => r.json().then(data => ({status: r.status, body: data})))
                    .then(obj => {
                        console.log(obj.body);
                        this.countries = obj.body;
                    });
            },
        }
    }
</script>

<!-- Cookie Consent by https://www.PrivacyPolicies.com -->
<script type="text/javascript" src="//www.privacypolicies.com/public/cookie-consent/4.0.0/cookie-consent.js"
        charset="UTF-8"></script>
<script type="text/javascript" charset="UTF-8">
    document.addEventListener('DOMContentLoaded', function () {
        cookieconsent.run({
            "notice_banner_type": "headline",
            "consent_type": "implied",
            "palette": "light",
            "language": "tr",
            "page_load_consent_levels": ["strictly-necessary", "functionality", "tracking", "targeting"],
            "notice_banner_reject_button_hide": false,
            "preferences_center_close_button_hide": false,
            "page_refresh_confirmation_buttons": false,
            "website_name": "Welldress"
        });
    });
</script>


</body>
</html>


<?php /**PATH /home/welldresscom/public_html/resources/views/pages/odeme-yap-mobile.blade.php ENDPATH**/ ?>