<?php

use App\Models\CartProduct;
use App\Models\Product;
use App\Models\OrderProduct;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use TCG\Voyager\Models\Category;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


Route::get('/test', [\App\Http\Controllers\Test::class, 'index']);
Route::get('/ismail', function () {
//    dd(\App\Models\Order::where('info->tc_number',"65149297384")->get());
   // dd(\App\Models\Order::where('ip_address',"159.146.71.189")->get());
    foreach (\App\Models\Order::where('ip_address',"176.240.103.78")->get() as $ord)
    {
        foreach (OrderProduct::where('order_id',$ord->id)->get() as $ordprd)
        {
            $ordprd->delete();
        }
        $ord->delete();
    }
dd(\App\Models\Order::where('ip_address',"176.240.103.78")->get());
dd(auth()->user()->id);

    App\Models\CartProduct::truncate();
});
Route::get('/truncate', function () {

//    App\Models\Order::truncate();
//    App\Models\OrderProduct::truncate();
//    App\Models\Product::truncate();
//    Voyager::model('category')->truncate();


});



Route::get('/', function () {
//    if (!(auth()->check()))
//        dd("1");

    
    $products = App\Models\Product::orderBy('order','ASC')->get();
    $with = [
        'products' => $products,
    ];
    return view('pages.index', $with);
});

Route::get('/hakkimizda', function () {

    $with = [
        //'products' => $products,
    ];
    return view('pages.hakkimizda', $with);
});
Route::get('/sitemap.xml', function () {
    return response(file_get_contents("public/storage/".(json_decode(setting('site.sitemap'),true)[0]['download_link'])), 200, [
        'Content-Type' => 'application/xml'
    ]);
});

Route::get('/iletisim', function () {

    $with = [
        //'products' => $products,
    ];
    return view('pages.iletisim', $with);
});

Route::get('/iptal-iade-sartlari', function () {

    $with = [
        //'products' => $products,
    ];
    return view('pages.iptal-iade-sartlari', $with);
});

Route::get('/gizlilik-politikasi', function () {

    $with = [
        //'products' => $products,
    ];
    return view('pages.gizlilik-politikasi', $with);
});

Route::get('/favoriler', function () {

    $with = [
        //'products' => $products,
    ];
    return view('pages.favoriler', $with);
});

Route::get('/kullanici-bilgileri', function () {

    $user = auth()->user();
//$talhaorder=App\Models\Order::where('user_id', 8)->get();
//    foreach ($talhaorder as $item) {
//        foreach ($item->order_products as $itemp) {
//            $itemp->delete();
//        }
//        $item->delete();
//
//
//}

    $orders = App\Models\Order::where('user_id', $user->id)->get();

    $bulletin = App\Models\Bulletin::firstWhere('email', $user->email);
    $liked_products = App\Models\LikedProduct::where('user_id', $user->id)->get();

    $with = [
        'user' => $user,
        'orders' => $orders,
        'bulletin' => $bulletin,
        'liked_products' => $liked_products,
    ];
    return view('pages.kullanici-bilgileri', $with);

})->middleware('auth');

Route::get('/mesafeli-satis-sozlesmesi', function () {

    $with = [
        //'products' => $products,
    ];
    return view('pages.mesafeli-satis-sozlesmesi', $with);
});

Route::get('/odeme-yap', function () {

    $cities = App\Models\City::orderBy('isim')->get();

    $with = [
        'cities' => $cities,
    ];
    return view('pages.odeme-yap', $with);
});
Route::get('/odeme-yap-mobil', function () {

    $cities = App\Models\City::orderBy('isim')->get();

    $with = [
        'cities' => $cities,
    ];
    return view('pages.odeme-yap-mobile', $with);
});
Route::get('/odeme-yontemleri', function () {

    $with = [
        //'products' => $products,
    ];
    return view('pages.odeme-yontemleri', $with);
});

Route::get('/sepetim', function () {

    $with = [
        //'products' => $products,
    ];
    return view('pages.sepetim', $with);
});

Route::get('/siparis-sorgula', function () {

    $with = [
        //'products' => $products,
    ];
    return view('pages.siparis-sorgula', $with);
});

Route::get('/siparis-takibi/{order:no}', function (App\Models\Order $order) {

    $with = [
        'order' => $order,
    ];
    return view('pages.siparis-takibi', $with);
});

Route::get('/siparisiniz-onaylandi', function () {

    $with = [
        //'products' => $products,
    ];
    return view('pages.siparisiniz-onaylandi', $with);
});

Route::get('/sss', function () {

    $with = [
        //'products' => $products,
    ];
    return view('pages.sss', $with);
});

Route::get('/teslimat-kosullari', function () {

    $with = [
        //'products' => $products,
    ];
    return view('pages.teslimat-kosullari', $with);
});

Route::get('/urunler', function () {

    $products = App\Models\Product::all();
    $most_populer_products = App\Models\Product::all();
    $with = [
        'products' => $products,
        'most_populer_products' => $most_populer_products,
    ];
    return view('pages.products.browse', $with);
});

Route::get('/urunler/{product:slug}', function (Product $product) {

    $other_products = App\Models\Product::all();
    $with = [
        'product' => $product,
        'other_products' => $other_products,
    ];
    return view('pages.products.read', $with);
});

Route::get('/urunler/kategori/{category:slug}', function (Category $category) {

    $products = Product::where('category_id', $category->id)->get();

    $most_populer_products = App\Models\Product::all();

    $with = [
        'products' => $products,
        'most_populer_products' => $most_populer_products
    ];
    return view('pages.products.browse', $with);
});

Route::post('/getCountry', function () {
    $city = \App\Models\City::firstWhere('isim', request()->get('city_name'));
    $countries = \App\Models\Country::where('il_no', $city->il_no)->get();
    return $countries;
});
Route::get('/kategori/{category:slug}', function (Category $category) {

    $products = Product::where('category_id', $category->id)->get();

    $most_populer_products = App\Models\Product::all();

    $with = [
        'products' => $products,
        'most_populer_products' => $most_populer_products
    ];
    return view('pages.products.browse', $with);
});
Route::post('/get-auth-user', [\App\Http\Controllers\Api::class, 'authUser']);

Route::post('/get-search-products', function (Request $request) {

    $products = Product::where('name', 'LIKE', '%' . $request->search . '%')->get();

    return $products;
});
Route::get('/test-urun', function () {
//      App\Models\Order::truncate();
//  App\Models\OrderProduct::truncate();
//  App\Models\CartProduct::truncate();
    dd(Product::first()->sale_price);
});
Route::post('/get-cart-products', function () {

    $where = [];
    if (auth()->check())
        $where['user_id'] = auth()->id();
    else
        $where['ip_address'] = request()->ip();

    $products = CartProduct::where($where)->with('product')->get();

    return $products;
});

Route::post('/set-cart-products', function () {

    $product_id = request()->get('product_id');
    $quantity = request()->get('quantity');
    $color = request()->get('color');
    $size = request()->get('size');

    $where = [
        'product_id' => $product_id,
        'size' => $size,
        'color' => $color,
    ];

    if (auth()->check())
        $where['user_id'] = auth()->id();
    else
        $where['ip_address'] = request()->ip();

    $product = CartProduct::firstOrNew($where);
    $product->quantity += $quantity;
    $product->color = $color;
    $product->size = $size;
    $product->save();


    /*    $product=\App\Models\CartProduct::where($where)->first();
        if(!$product)
        {
            $product = new \App\Models\CartProduct();
            $product->product_id=$product_id;
            $product->ip_address=request()->ip();

        }

        $product->quantity += $quantity;
        $product->save();*/
    return $product;
});

Route::post('/delete-cart-products', function () {

    $product_id = request()->get('product_id');
    $quantity = request()->get('quantity');

    $where = [
        'product_id' => $product_id,
    ];
    if (auth()->check())
        $where['user_id'] = auth()->id();
    else
        $where['ip_address'] = request()->ip();

    $product = CartProduct::firstWhere($where);

    if ($product) {
        if ($quantity == 0) {
            $product->delete();
        } else {
            $product->quantity -= $quantity;
            $product->save();
        }
    }

    return response()->json('success');
});

Route::post('/chance-cart-product-quantity', function () {

    $product_id = request()->get('product_id');
    $quantity = request()->get('quantity');
    $size = request()->get('size');

    $where = [
        'product_id' => $product_id,
        'size' => $size,
    ];
    if (auth()->check())
        $where['user_id'] = auth()->id();
    else
        $where['ip_address'] = request()->ip();

    $product = CartProduct::firstWhere($where);

    if ($product) {
        $product->quantity = $quantity;
        $product->save();
    }

    return response()->json('success');
});

Route::post('/odeme-sonuc', [\App\Iyzico\Iyzipay::class, 'checkoutForm']);

Route::post('/checkout', [\App\Iyzico\Iyzipay::class, 'checkoutFormInitialize']);

Route::post('/wettable-powder', function (Request $request) {

    if (!auth()->check())
        return response()->json(['error' => 'auth']);

    $validate = [
        'name' => 'required',
        'lastname' => 'required',
        'address' => 'required',
        'phone' => 'required',
        'email' => 'required|email:rfc,dns',
    ];
    $validateMessage = [
        'name.required' => 'Ad zorunludur.',
        'lastname.required' => 'Soyad zorunludur.',
        'address.required' => 'Adres zorunludur.',
        'phone.required' => 'Telefon zorunludur.',
        'email.required' => 'Email zorunludur.',
        'email.email' => 'Geçerli bir email adresi giriniz.',
    ];

    $validator = Validator::make(request()->all(), $validate, $validateMessage);

    if ($validator->fails()) {
        return response()->json($validator->errors(), 400);
    }

    $user_id = 0;
    $total = 0;

    $where = [];
    if (auth()->check())
    {
        $user_id =  auth()->id();
        $where['user_id'] = $user_id;
    }
    else
        $where['ip_address'] = request()->ip();

    $cart_products = CartProduct::where($where)->with('product')->get();


    do {
        $code = $user_id . date('Y') . hexdec(uniqid());
    } while (Order::where("no", "=", $code)->first());

    $order = new Order;

    if (auth()->check())
        $order->user_id = $user_id;
    else
        $order->ip_address = request()->ip();
    $order->payment_status = 'odeme_bekliyor';
    $order->payment_type = 'wettable_powder';

    $order->info = $request->collect();
    $order->no = $code;

    if ($order->save()) {
        foreach ($cart_products as $cart) {
            $order_product = new OrderProduct;
            $order_product->order_id = $order->id;
            $order_product->product_id = $cart->product_id;
            $order_product->quantity = $cart->quantity;
            $order_product->price = $cart->product->price;
            $order_product->sale_price = $cart->product->sale_price;
            $order_product->discount_rate = $cart->product->discount_rate;
            $order_product->category_id = $cart->product->category_id;
            $order_product->product_name = $cart->product->name;
            $order_product->category_name = $cart->product->category->name;
            $order_product->product_image = $cart->product->product_image;
            $order_product->sku = $cart->product->sku;
            $order_product->size = "$cart->size";
            $order_product->color = "$cart->color";
            $order_product->save();
            /*if ($order_product->save())
                $cart->delete();*/

            $total += $order_product->quantity * $order_product->sale_price;
        }
        $order->total_price = $total;
        $order->save();
    }

    $html = '<script>window.location.replace("' . url('/siparis/' . $order->no) . '");</script>';
    return response()->json($html);

})->middleware('auth');

Route::post('/bulletin', function () {

    $validatedData = request()->validate([
        'email' => 'required|email|unique:bulletins|max:255',
    ], [
        'email.required' => 'Email zorunludur.',
        'email.email' => 'Email adresi giriniz.',
        'email.unique' => 'Email adresi ile zaten abone olunmuş.',
    ]);

    $bulletin = new \App\Models\Bulletin;
    $bulletin->email = request()->get('email');
    $bulletin->save();

    return back()->with('message', 'Abone olunmuştur.');
});

Route::post('/iletisim', function () {

    $validatedData = request()->validate([
        'first_name' => 'required',
        'last_name' => 'required',
        'email' => 'required|email:rfc,dns',
        'message' => 'required',
    ], [
        'first_name.required' => 'Ad zorunludur.',
        'last_name.required' => 'Soyad zorunludur.',
        'email.required' => 'Email zorunludur.',
        'email.email' => 'Geçerli bir email adresi giriniz.',
        'message.required' => 'Mesaj zorunludur.',
    ]);

    $contact = new \App\Models\Contact;
    $contact->first_name = request()->get('first_name');
    $contact->last_name = request()->get('last_name');
    $contact->email = request()->get('email');
    $contact->message = request()->get('message');
    $contact->save();

    return back()->with('message', 'Mesajınız iletilmiştir.');
});

Route::post('/begendigim-urunler', function (Request $request) {
    $user_id = auth()->id();
    $array = ['user_id' => $user_id, 'product_id' => $request->product_id];
    $liked_product = \App\Models\LikedProduct::firstWhere($array);

    $liked_product = $liked_product ? $liked_product->delete() : \App\Models\LikedProduct::create($array);

    return response()->json($liked_product);
});

Route::post('/edit-account', function (Request $request) {

    $user_id = auth()->id();
    $user = App\Models\User::find($user_id);

    $rules = [
        'name' => ['required', 'string', 'max:255'],
        'email' => ['required', 'string', 'email', 'max:255'],
        'phone' => ['required', 'string', 'max:255'],
    ];

    if ($request->email != $user->email)
        $rules['email'] = ['required', 'string', 'email', 'max:255', 'unique:users'];

    if ($request->phone != $user->phone)
        $rules['phone'] = ['required', 'string', 'max:255', 'unique:users'];

    $messages = [
        'name.required' => 'Ad Soyad Mutalaka Gereklidir.',
        'email.required' => 'Email Mutalaka Gereklidir.',
        'email.email' => 'Geçerli bir email adresi giriniz.',
        'email.unique' => 'Email ile zaten kayıt olunmuş.',
        'phone.required' => 'Telefon Mutalaka Gereklidir.',
        'phone.unique' => 'Telefon ile zaten kayıt olunmuş.',
    ];

    $request->validate($rules, $messages);

    $user->name = $request->name;
    $user->email = $request->email;
    $user->phone = $request->phone;

    $user->save();

    return back();
})->name('edit.account');

Route::post('change-password', 'App\Http\Controllers\ChangePasswordController@store')->name('change.password');

require __DIR__ . '/auth.php';
require __DIR__ . '/voyager.php';
