@extends('voyager::master')

@section('page_title', __('voyager::generic.view').' '.$dataType->getTranslatedAttribute('display_name_singular'))

@section('page_header')
    <h1 class="page-title">
        <i class="{{ $dataType->icon }}"></i> {{ __('voyager::generic.viewing') }} {{ ucfirst($dataType->getTranslatedAttribute('display_name_singular')) }}
        &nbsp;

        @can('edit', $dataTypeContent)
            <a href="{{ route('voyager.'.$dataType->slug.'.edit', $dataTypeContent->getKey()) }}" class="btn btn-info">
                <i class="glyphicon glyphicon-pencil"></i> <span
                        class="hidden-xs hidden-sm">{{ __('voyager::generic.edit') }}</span>
            </a>
        @endcan
        @can('delete', $dataTypeContent)
            @if($isSoftDeleted)
                <a href="{{ route('voyager.'.$dataType->slug.'.restore', $dataTypeContent->getKey()) }}"
                   title="{{ __('voyager::generic.restore') }}" class="btn btn-default restore"
                   data-id="{{ $dataTypeContent->getKey() }}" id="restore-{{ $dataTypeContent->getKey() }}">
                    <i class="voyager-trash"></i> <span
                            class="hidden-xs hidden-sm">{{ __('voyager::generic.restore') }}</span>
                </a>
            @else
                <a href="javascript:;" title="{{ __('voyager::generic.delete') }}" class="btn btn-danger delete"
                   data-id="{{ $dataTypeContent->getKey() }}" id="delete-{{ $dataTypeContent->getKey() }}">
                    <i class="voyager-trash"></i> <span
                            class="hidden-xs hidden-sm">{{ __('voyager::generic.delete') }}</span>
                </a>
            @endif
        @endcan
        @can('browse', $dataTypeContent)
            <a href="{{ route('voyager.'.$dataType->slug.'.index') }}" class="btn btn-warning">
                <i class="glyphicon glyphicon-list"></i> <span
                        class="hidden-xs hidden-sm">{{ __('voyager::generic.return_to_list') }}</span>
            </a>
        @endcan
    </h1>
    @include('voyager::multilingual.language-selector')
@stop

@section('content')
    <div class="page-content read container-fluid">
        <div class="row">
            <div id="333" class="col-md-12 panel panel-bordered">
                <div class="table-responsive shopping-summery">

                    <table class="table table-wishlist">
                        <thead>
                        <tr class="main-heading">
                            <th scope="col" colspan="2">Ürün</th>

                            <th scope="col">Fiyat</th>
                            <th scope="col">Adet</th>
                            <th scope="col">Toplam</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($dataTypeContent->order_products as $orpr)

                            <tr class="pt-30">
                                <td class="image product-thumbnail pt-40">
                                    <img style="height:77px;"
                                         src="{{ Voyager::image($orpr->product_image) }}"
                                         alt="{{ $orpr->product_name . " (". $orpr->size. " - ". $orpr->color . " )" }}"></td>
                                <td class="product-des product-name">
                                    <h6><a class="product-name mb-10"
                                           href="{{ url('urunler/'.($orpr->product?$orpr->product->slug:'')) }}">{{ $orpr->product_name . " (". $orpr->size. " - ". $orpr->color . " )" }}</a>
                                    </h6>
                                </td>

                                <td class="price" data-title="Price">
                                    <h3 class="text-brand">{{ $orpr->sale_price }} ₺</h3>
                                </td>
                                <td class="quantity" data-title="Quantity">
                                    <h3 class="text-brand">{{  $orpr->quantity }} </h3>
                                </td>
                                <td class="price" data-title="Price">
                                    <h3 class="text-brand">
                                        {{ $orpr->total_price }} ₺</h3>
                                </td>

                            </tr>
                        @endforeach

                        </tbody>
                    </table>
                </div>
            </div>
            <div id="1" class="col-md-6 panel panel-bordered">
                @if(isset($dataTypeContent->info))

                    <div class="panel-heading" style="border-bottom:0;">
                        <h3 class="panel-title">Ad</h3>
                    </div>
                    <div class="panel-body" style="padding-top:0;">
                        {{ $dataTypeContent->info->first_name }}
                    </div>

                    <div class="panel-heading" style="border-bottom:0;">
                        <h3 class="panel-title">Soyad</h3>
                    </div>
                    <div class="panel-body" style="padding-top:0;">
                        {{ $dataTypeContent->info->last_name }}
                    </div>
                    <div class="panel-heading" style="border-bottom:0;">
                        <h3 class="panel-title">Tc Kimlik No</h3>
                    </div>
                    <div class="panel-body" style="padding-top:0;">
                        {{ $dataTypeContent->info->tc_number }}
                    </div>
                    <div class="panel-heading" style="border-bottom:0;">
                        <h3 class="panel-title">Email</h3>
                    </div>
                    <div class="panel-body" style="padding-top:0;">
                        <a href="mailto:{{$dataTypeContent->info->email}}">
                            {{ $dataTypeContent->info->email }}
                        </a>
                    </div>

                    <div class="panel-heading" style="border-bottom:0;">
                        <h3 class="panel-title">Telefon</h3>
                    </div>
                    <div class="panel-body" style="padding-top:0;">
                        <a href="tel:{{$dataTypeContent->info->phone}}">
                            {{ $dataTypeContent->info->phone }}
                        </a>
                    </div>

                    <div class="panel-heading" style="border-bottom:0;">
                        <h3 class="panel-title">Adres</h3>
                    </div>
                    <div class="panel-body" style="padding-top:0;">
                        {{ $dataTypeContent->info->address }}
                    </div>

                    <div class="panel-heading" style="border-bottom:0;">
                        <h3 class="panel-title">Şehir</h3>
                    </div>
                    <div class="panel-body" style="padding-top:0;">
                        {{ $dataTypeContent->info->province }}
                    </div>

                    <div class="panel-heading" style="border-bottom:0;">
                        <h3 class="panel-title">İlçe</h3>
                    </div>
                    <div class="panel-body" style="padding-top:0;">
                        {{ $dataTypeContent->info->district }}
                    </div>

                    <div class="panel-heading" style="border-bottom:0;">
                        <h3 class="panel-title">Posta kodu</h3>
                    </div>
                    <div class="panel-body" style="padding-top:0;">
                        {{ $dataTypeContent->info->zip_code }}
                    </div>

                    <div class="panel-heading" style="border-bottom:0;">
                        <h3 class="panel-title">Burç</h3>
                    </div>
                    <div class="panel-body" style="padding-top:0;">
                        {{ $dataTypeContent->info->burc }}
                    </div>
                @endif
            </div>

            <div class="col-md-6">

                <div class="panel panel-bordered" style="padding-bottom:5px;">
                    <!-- form start -->

                    @foreach($dataType->readRows as $row)
                        @php
                            if ($dataTypeContent->{$row->field.'_read'}) {
                                $dataTypeContent->{$row->field} = $dataTypeContent->{$row->field.'_read'};
                            }
                        @endphp
                        <div class="panel-heading" style="border-bottom:0;">
                            <h3 class="panel-title">{{ $row->getTranslatedAttribute('display_name') }}</h3>
                        </div>



                        <div class="panel-body" style="padding-top:0;">
                            @if (isset($row->details->view))

                                @include($row->details->view, ['row' => $row, 'dataType' => $dataType, 'dataTypeContent' => $dataTypeContent, 'content' => $dataTypeContent->{$row->field}, 'action' => 'read', 'view' => 'read', 'options' => $row->details])
                            @elseif($row->type == "image")
                                <img class="img-responsive"
                                     src="{{ filter_var($dataTypeContent->{$row->field}, FILTER_VALIDATE_URL) ? $dataTypeContent->{$row->field} : Voyager::image($dataTypeContent->{$row->field}) }}">
                            @elseif($row->type == 'multiple_images')

                                @if(json_decode($dataTypeContent->{$row->field}))
                                    @foreach(json_decode($dataTypeContent->{$row->field}) as $file)
                                        <img class="img-responsive"
                                             src="{{ filter_var($file, FILTER_VALIDATE_URL) ? $file : Voyager::image($file) }}">
                                    @endforeach
                                @else
                                    <img class="img-responsive"
                                         src="{{ filter_var($dataTypeContent->{$row->field}, FILTER_VALIDATE_URL) ? $dataTypeContent->{$row->field} : Voyager::image($dataTypeContent->{$row->field}) }}">
                                @endif
                            @elseif($row->type == 'relationship')

                                @include('voyager::formfields.relationship', ['view' => 'read', 'options' => $row->details])
                            @elseif($row->type == 'select_dropdown' && property_exists($row->details, 'options') &&
                                    !empty($row->details->options->{$dataTypeContent->{$row->field}})
                            )

                                <?php echo $row->details->options->{$dataTypeContent->{$row->field}};?>
                            @elseif($row->type == 'select_multiple')
                                @if(property_exists($row->details, 'relationship'))

                                    @foreach(json_decode($dataTypeContent->{$row->field}) as $item)
                                        {{ $item->{$row->field}  }}
                                    @endforeach

                                @elseif(property_exists($row->details, 'options'))

                                    @if (!empty(json_decode($dataTypeContent->{$row->field})))
                                        @foreach(json_decode($dataTypeContent->{$row->field}) as $item)
                                            @if (@$row->details->options->{$item})
                                                {{ $row->details->options->{$item} . (!$loop->last ? ', ' : '') }}
                                            @endif
                                        @endforeach
                                    @else

                                        {{ __('voyager::generic.none') }}
                                    @endif
                                @endif
                            @elseif($row->type == 'date' || $row->type == 'timestamp')
                                @if ( property_exists($row->details, 'format') && !is_null($dataTypeContent->{$row->field}) )
                                    {{ \Carbon\Carbon::parse($dataTypeContent->{$row->field})->formatLocalized($row->details->format) }}
                                @else
                                    {{ $dataTypeContent->{$row->field} }}

                                @endif
                            @elseif($row->type == 'checkbox')
                                @if(property_exists($row->details, 'on') && property_exists($row->details, 'off'))
                                    @if($dataTypeContent->{$row->field})
                                        <span class="label label-info">{{ $row->details->on }}</span>
                                    @else
                                        <span class="label label-primary">{{ $row->details->off }}</span>
                                    @endif
                                @else
                                    {{ $dataTypeContent->{$row->field} }}
                                @endif
                            @elseif($row->type == 'color')
                                <span class="badge badge-lg"
                                      style="background-color: {{ $dataTypeContent->{$row->field} }}">{{ $dataTypeContent->{$row->field} }}</span>
                            @elseif($row->type == 'coordinates')
                                @include('voyager::partials.coordinates')
                            @elseif($row->type == 'rich_text_box')
                                @include('voyager::multilingual.input-hidden-bread-read')
                                {!! $dataTypeContent->{$row->field} !!}
                            @elseif($row->type == 'file')
                                @if(json_decode($dataTypeContent->{$row->field}))
                                    @foreach(json_decode($dataTypeContent->{$row->field}) as $file)
                                        <a href="{{ Storage::disk(config('voyager.storage.disk'))->url($file->download_link) ?: '' }}">
                                            {{ $file->original_name ?: '' }}
                                        </a>
                                        <br/>
                                    @endforeach
                                @else

                                    <a href="{{ Storage::disk(config('voyager.storage.disk'))->url($row->field) ?: '' }}">
                                        {{ __('voyager::generic.download') }}
                                    </a>
                                @endif
                            @else
                                @include('voyager::multilingual.input-hidden-bread-read')
                                <p>{{ $dataTypeContent->{$row->field} }} @if($row->field=="total_price")
                                        ₺
                                    @endif</p>
                            @endif
                        </div><!-- panel-body -->
                        @if(!$loop->last)
                            <hr style="margin:0;">
                        @endif
                    @endforeach


                </div>
            </div>

        </div>
    </div>

    {{-- Single delete modal --}}
    <div class="modal modal-danger fade" tabindex="-1" id="delete_modal" role="dialog">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal"
                            aria-label="{{ __('voyager::generic.close') }}"><span aria-hidden="true">&times;</span>
                    </button>
                    <h4 class="modal-title"><i
                                class="voyager-trash"></i> {{ __('voyager::generic.delete_question') }} {{ strtolower($dataType->getTranslatedAttribute('display_name_singular')) }}
                        ?</h4>
                </div>
                <div class="modal-footer">
                    <form action="{{ route('voyager.'.$dataType->slug.'.index') }}" id="delete_form" method="POST">
                        {{ method_field('DELETE') }}
                        {{ csrf_field() }}
                        <input type="submit" class="btn btn-danger pull-right delete-confirm"
                               value="{{ __('voyager::generic.delete_confirm') }} {{ strtolower($dataType->getTranslatedAttribute('display_name_singular')) }}">
                    </form>
                    <button type="button" class="btn btn-default pull-right"
                            data-dismiss="modal">{{ __('voyager::generic.cancel') }}</button>
                </div>
            </div><!-- /.modal-content -->
        </div><!-- /.modal-dialog -->
    </div><!-- /.modal -->
@stop

@section('javascript')
    @if ($isModelTranslatable)
        <script>
            $(document).ready(function () {
                $('.side-body').multilingual();
            });
        </script>
    @endif
    <script>
        var deleteFormAction;
        $('.delete').on('click', function (e) {
            var form = $('#delete_form')[0];

            if (!deleteFormAction) {
                // Save form action initial value
                deleteFormAction = form.action;
            }

            form.action = deleteFormAction.match(/\/[0-9]+$/)
                ? deleteFormAction.replace(/([0-9]+$)/, $(this).data('id'))
                : deleteFormAction + '/' + $(this).data('id');

            $('#delete_modal').modal('show');
        });

    </script>
@stop
