@extends('layouts.default')

@section('css')

@endsection

@section('content')

    <!-- Breadcrumb section start -->

    <section class="breadcrumb-section section-b-space">

        <ul class="circles">

            <li></li>

            <li></li>

            <li></li>

            <li></li>

            <li></li>

            <li></li>

            <li></li>

            <li></li>

            <li></li>

            <li></li>

        </ul>

        <div class="container">

            <div class="row">

                <div class="col-12">

                    <h3>Sipariş Takibi</h3>

                    <nav>

                        <ol class="breadcrumb">

                            <li class="breadcrumb-item">

                                <a href="{{ url('/') }}">

                                    <i class="fas fa-home"></i>

                                </a>

                            </li>

                            <li class="" aria-current="page">Anasayfa</li>

                        </ol>

                    </nav>

                </div>

            </div>

        </div>

    </section>

    <!-- Breadcrumb section end -->

    <!-- Order Track Section Start -->

    <section class="section-b-space">

        <div class="container">

            <div class="row">

                <div class="col-12 overflow-hidden">

                    <div class="order-left-image ratio_asos">

                        {{-- <div class="tracking-product-image">

                             <img src="{{ asset('assets/images/fashion/banner/3.jpg') }}" class="img-fluid bg-img blur-up lazyload"

                                  alt="">

                         </div>--}}


                        <div class="order-image-contain">

                            <div class="tracker-number">

                                <p class="font-light">Sipariş numarası : <span>{{ $order->no }}</span></p>

                                <!--                            <p class="font-light">Brand : <span>Van Heusen</span></p>-->

                                <p class="font-light">Sipariş Tarihi :
                                    <span>{{ $order->created_at->format('d.m.Y') }}</span></p>

                                <p class="font-light">Sipariş Durumu :
                                    <span>{{ $order->getStatus() }}</span></p>

                                <p class="font-light">Kargo Firması : <span>{{ $order->getCargoCompany() }}</span></p>

                                <p class="font-light">Kargo Takip Numarası : <span>{{ $order->cargo_code }}</span></p>
                                <p class="font-light">Burç : <span>{{ $order->info->burc }}</span></p>

                            </div>

                            <ol class="progtrckr">

                                <li class="{{ $order->status >= 0 ?'progtrckr-done' : 'progtrckr-todo' }}">

                                    <h5>Sipariş Kontrol Ediliyor</h5>

                                </li>

                                <li class="{{ $order->status >= 1 ?'progtrckr-done' : 'progtrckr-todo' }}">

                                    <h5>Siparişiniz Hazırlanıyor</h5>

                                </li>

                                <li class="{{ $order->status >= 2 ?'progtrckr-done' : 'progtrckr-todo' }}">

                                    <h5>Siparişiniz Hazırlandı</h5>

                                </li>

                                <li class="{{ $order->status >= 3 ?'progtrckr-done' : 'progtrckr-todo' }}">

                                    <h5>Kargoya Verildi</h5>

                                </li>

                                <li class="{{ $order->status >= 4 ?'progtrckr-done' : 'progtrckr-todo' }}">

                                    <h5>Teslim Edildi</h5>

                                </li>

                            </ol>


                            {{--<h5 class="font-light">Siparişiniz yolda. İzleme bilgileri 24 saat içinde mevcut olacaktır.</h5>--}}

                        </div>

                    </div>

                </div>


                <div class="col-12 overflow-visible">

                    <div class="tracker-table">

                        <div class="table-responsive">

                            <table class="table">

                                <thead>

                                <tr class="table-head">

                                    <th scope="col">Ürün Resmi</th>

                                    <th scope="col">Ürün Adı</th>

                                    <th scope="col">Adet</th>

                                    <th scope="col">Fiyat</th>

                                    <th scope="col">Toplam</th>

                                </tr>

                                </thead>


                                <tbody>

                                @foreach($order->order_products as $op)

                                    @php $product = $op->product?$op->product:null; @endphp
                                    <tr>

                                        <td>

                                            <a href="{{ $product?url('urunler/'.$product->slug):'#' }}">

                                                <img src="{{ Voyager::image($op->product_image) }}" width="100"

                                                     class="blur-up lazyload" alt="{{ $op->product_name }}">

                                            </a>

                                        </td>

                                        <td>

                                            <p class="fs-6 m-0">{{ $op->product_name." (".$op->size." - ".$op->color.") " }}</p>

                                        </td>

                                        <td>

                                            <p class="theme-color fs-6">{{ $op->quantity }} Adet</p>

                                        </td>

                                        <td>

                                            <p class="theme-color fs-6">{{ $op->sale_price }} ₺</p>

                                        </td>

                                        <td>

                                            <p class="theme-color fs-6">{{ $op->total_price }} ₺</p>

                                        </td>

                                    </tr>
                                @endforeach


                                </tbody>

                            </table>

                        </div>

                    </div>

                </div>

            </div>

        </div>

    </section>

    <!-- Order Track Section End -->

@endsection

@section('js')

@endsection