@extends('layouts.default')

@section('css')

@endsection

@section('content')

    <!-- Breadcrumb section start -->

    <section class="breadcrumb-section section-b-space">

        <ul class="circles">

            <li></li>

            <li></li>

            <li></li>

            <li></li>

            <li></li>

            <li></li>

            <li></li>

            <li></li>

            <li></li>

            <li></li>

        </ul>

        <div class="container">

            <div class="row">

                <div class="col-12">

                    <h3>Favoriler</h3>

                    <nav>

                        <ol class="breadcrumb">

                            <li class="breadcrumb-item">

                                <a href="{{ url('/') }}">

                                    <i class="fas fa-home"></i>

                                </a>

                            </li>

                            <li class="" aria-current="page">Anasayfa</li>

                        </ol>

                    </nav>

                </div>

            </div>

        </div>

    </section>

    <!-- Breadcrumb section end -->

    <!-- Cart Section Start -->

    <section class="wish-list-section section-b-space">

        <div class="container">

            <div class="row">

                <div class="col-sm-12 table-responsive">

                    <table class="table cart-table wishlist-table">

                        <thead>

                        <tr class="table-head">

                            <th scope="col">Ürün Resmi</th>

                            <th scope="col">Ürün Adı</th>

                            <th scope="col">Fiyat</th>

                            <th scope="col"></th>

                        </tr>

                        </thead>

                        <tbody>


                        @foreach(App\Models\LikedProduct::where('user_id',auth()->id())->get() as $lproduct)
                            @if($lproduct->product)
                            <tr>
                                <td>

                                    <a href="{{ url('urunler/'.$lproduct->product->slug) }}">

                                        <img src="{{ Voyager::image($lproduct->product->image) }}"
                                             class="blur-up lazyload"

                                             alt="{{ $lproduct->product->name }}">

                                    </a>

                                </td>

                                <td>

                                    <a href="{{ url('urunler/'.$lproduct->product->slug) }}" class="font-light">{{ $lproduct->product->name }}</a>

                                    <div class="mobile-cart-content row">

                                        <div class="col">

                                            <p class="fw-bold">{{ $lproduct->product->sale_price }} ₺</p>

                                        </div>

                                        <div class="col">

                                            <h2 class="td-color">

                                                <a @click.debounce="addToWishlist({{ $lproduct->product->id }})" class="icon pointer">

                                                    <i class="fas fa-times"></i>

                                                </a>

                                            </h2>

                                            <h2 class="td-color">

                                                <a @click.debounce="setCartProduct({{ $lproduct->product->id }})" class="icon pointer">

                                                    <i class="fas fa-shopping-cart"></i>

                                                </a>

                                            </h2>

                                        </div>

                                    </div>

                                </td>

                                <td>

                                    <p class="fw-bold">{{ $lproduct->product->sale_price }} ₺</p>

                                </td>

                                <td>

                                    <a @click.debounce="addToWishlist({{ $lproduct->product->id }});location.reload();" class="icon pointer">

                                        <i class="fas fa-times"></i>

                                    </a>

                                    <a @click.debounce="setCartProduct({{ $lproduct->product->id }})" class="icon pointer">

                                        <i class="fas fa-shopping-cart"></i>

                                    </a>

                                </td>

                            </tr>
                            @endif
                        @endforeach

                        </tbody>
                    </table>

                </div>

            </div>

        </div>

    </section>

    <!-- Cart Section End -->

@endsection

@section('js')

@endsection