@extends('layouts.default')

@section('css')

@endsection

@section('content')

    <!-- Log In Section Start -->

    <div class="login-section">

        <div class="materialContainer">

            <div class="box">

                <div class="login-title">

                    <h2>Giriş Yap</h2>

                </div>

                <!-- Session Status -->
                {{--<x-auth-session-status class="mb-4" :status="session('status')" />--}}

                <!-- Validation Errors -->
                <x-auth-validation-errors class="mb-4" :errors="$errors" />

                <form method="POST" action="{{ route('login') }}">
                    @csrf
                    <div class="input">

                        <label for="email">Email</label>

                        <input id="email" type="email" name="email" value="{{ old('email') }}" required>

                        <span class="spin"></span>

                        <div class="valid-feedback">

                            Lütfen Email doldurun

                        </div>

                    </div>


                    <div class="input">

                        <label for="password">Şifre</label>

                        <input id="password" type="password" name="password"
                               required autocomplete="current-password">

                        <span class="spin"></span>

                    </div>


                    <label for="remember_me" class="inline-flex items-center mt-3">
                        <input id="remember_me" type="checkbox" class="rounded border-gray-300 text-indigo-600 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50" name="remember">
                        <span class="ml-2 text-sm text-gray-600">Beni Hatırla</span>
                    </label>



                    @if (Route::has('password.request'))
                        <a class="pass-forgot" href="{{ route('password.request') }}">
                            Şifrenizi mi unuttunuz?
                        </a>
                    @endif




                    <div class="button login">

                        <button type="submit">

                            <span>GİRİŞ YAP</span>

                            <i class="fa fa-check"></i>

                        </button>

                    </div>
                </form>



{{--                <p class="sign-category">

                    <span>Veya şununla oturum açın:</span>

                </p>



                <div class="row gx-md-3 gy-3">

                    <div class="col-md-6">

                        <a href="www.facebook.html">

                            <div class="social-media fb-media">

                                <img src="assets/images/inner-page/facebook.png" class="img-fluid blur-up lazyload"

                                     alt="">

                                <h6>Facebook</h6>

                            </div>

                        </a>

                    </div>

                    <div class="col-md-6">

                        <a href="www.gmail.html">

                            <div class="social-media google-media">

                                <img src="assets/images/inner-page/google.png" class="img-fluid blur-up lazyload"

                                     alt="">

                                <h6>Google</h6>

                            </div>

                        </a>

                    </div>

                </div>--}}



                <p>Üye değil?  <a href="{{ route('register') }}" class="theme-color"> Şimdi kayıt ol</a></p>



            </div>

        </div>

    </div>

    <!-- Log In Section End -->

@endsection

@section('js')
    <script>

        document.getElementById("email").click();
    </script>

@endsection