<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Model;
use TCG\Voyager\Facades\Voyager;


class OrderProduct extends Model
{
    protected $appends = ['discount', 'sale_price', 'total_price'];

    //protected $fillable = ['product_id', 'user_id', 'ip_address', 'quantity'];

    public function product()
    {
        return $this->belongsTo('App\Models\Product');
    }

    public function category()
    {
        return $this->belongsTo(Voyager::model('Category'));
    }

    public function totalPrice(): Attribute
    {
        $attribute = Attribute::make(
            get: fn() => $this->sale_price * $this->quantity,
        //get: fn() => $this->price - ($this->price * $this->discount_rate / 100),
        );
        return $attribute;
    }

    public function discount(): Attribute
    {
        $attribute = Attribute::make(
            get: fn() => $this->discount_rate == 0 ? false : true,
        );
        return $attribute;
    }

    public function salePrice(): Attribute
    {
        $attribute = Attribute::make(
            get: fn() => $this->discount ? (100 - $this->discount_rate) * $this->price / 100 : $this->price,
        //get: fn() => $this->price - ($this->price * $this->discount_rate / 100),
        );
        return $attribute;
    }
}
